package com.lcrx.selector.aop.implement;

import com.lcrx.selector.enums.LogType;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

@Builder
@Getter
@NoArgsConstructor
@AllArgsConstructor
@Component
@Scope(value = WebApplicationContext.SCOPE_REQUEST, proxyMode = ScopedProxyMode.TARGET_CLASS)
public class BusinessLogData {

    private boolean enabled;
    private String action;
    private String module;
    private LogType logType;
    private String operator;
    private String remark;
    private Object payload;
    private Object response;
    private String requestMethod;
    private String uri;
    private String url;
    private String loginUser;
    private long took;
    private String headerContext;

    public BusinessLogData activate() {
        enabled = true;
        return this;
    }

    public BusinessLogData setAction(String actionNew) {
        action = actionNew;
        return this;
    }

    public BusinessLogData setModule(String moduleNew) {
        module = moduleNew;
        return this;
    }

    public BusinessLogData setLogType(LogType logTypeNew) {
        logType = logTypeNew;
        return this;
    }

    public BusinessLogData setOperator(String operatorNew) {
        operator = operatorNew;
        return this;
    }

    public BusinessLogData setRemark(String remarkNew) {
        remark = remarkNew;
        return this;
    }

    public BusinessLogData setPayload(Object payloadNew) {
        payload = payloadNew;
        return this;
    }

    public BusinessLogData setResponse(Object responseNew) {
        response = responseNew;
        return this;
    }

    public BusinessLogData setRequestMethod(String requestMethodNew) {
        requestMethod = requestMethodNew;
        return this;
    }

    public BusinessLogData setUri(String uriNew) {
        uri = uriNew;
        return this;
    }

    public BusinessLogData setUrl(String urlNew) {
        url = urlNew;
        return this;
    }

    public BusinessLogData setLoginUser(String loginUserNew) {
        loginUser = loginUserNew;
        return this;
    }

    public BusinessLogData setTook(long tookNew) {
        took = tookNew;
        return this;
    }

    public BusinessLogData setHeaderContext(String headerContextNew) {
        headerContext = headerContextNew;
        return this;
    }
}
