package com.lcrx.selector.api;

import com.alibaba.fastjson.JSON;
import com.lcrx.selector.aop.definition.BusinessLog;
import com.lcrx.selector.constant.RedisKey;
import com.lcrx.selector.utils.RedisHelper;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

@Api(tags = "ops", value = "ops")
@RestController
@RequestMapping(value = "/api/v1/ops")
@Slf4j
public class OpsController {
    private final RedisHelper redisHelper;
    private final RedisTemplate<String, String> redisTemplate;

    @Autowired
    public OpsController(RedisHelper redisHelper, RedisTemplate<String, String> redisTemplate) {
        this.redisHelper = redisHelper;
        this.redisTemplate = redisTemplate;
    }

    @PostMapping("/variantTable")
    @BusinessLog
    public void setVariantTable(@RequestBody String redis) {
        ValueOperations<String, String> operations = redisTemplate.opsForValue();
        redisHelper.set(RedisKey.getVariantTableKey("cf", "03", "10G4CTO1WW"), redis);
    }

    @PostMapping("/debug")
    @BusinessLog
    public String test() {
        Map<String, String> tempMap = new HashMap<>();

        tempMap.put("1","a");
        tempMap.put("2","b");

        return JSON.toJSONString(tempMap);
    }
}
