package com.lcrx.selector.api.v1;

import com.lcrx.selector.aop.definition.BusinessLog;
import com.lcrx.selector.entity.DTO.*;
import com.lcrx.selector.service.SelectorService;
import com.lcrx.selector.utils.result.Result;
import com.lcrx.selector.utils.result.ResultCode;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * @author ###
 */
@Api(tags = "selector", value = "selector")
@RestController
@RequestMapping(value = "/api/v1/selector")
@Slf4j
public class SelectorController {
    private final SelectorService selectorService;

    @Autowired
    public SelectorController(SelectorService selectorService) {
        this.selectorService = selectorService;
    }

    @PostMapping("/initialization")
    @BusinessLog
    public Result<InitializationOutputDTO> initialization(@Valid @RequestBody InitializationInputDTO initializationInputDTO,
                                                          Errors errors)
    {
        //校验处理
        if(errors.hasErrors())
        {
            return Result.genResult(ResultCode.INPUT_DATA_ERROR.getCode(), ResultCode.INPUT_DATA_ERROR.getMsg());
        }

        return Result.ok(selectorService.initialization(initializationInputDTO));
    }

    @PostMapping("/preVerify")
    @BusinessLog
    public Result<PreVerifyOutputDTO> preVerify(@Valid @RequestBody PreVerifyInputDTO preVerifyInputDTO,
                                                Errors errors)
    {
        //校验处理
        if(errors.hasErrors())
        {
            return Result.genResult(ResultCode.INPUT_DATA_ERROR.getCode(), ResultCode.INPUT_DATA_ERROR.getMsg());
        }

        return Result.ok(selectorService.preVerify(preVerifyInputDTO));
    }

    @PostMapping("/buildConfiguration")
    @BusinessLog
    public Result<BuildConfigurationOutputDTO> buildConfiguration(@Valid @RequestBody BuildConfigurationInputDTO buildConfigurationInputDTO,
                                                                  Errors errors)
    {
        //校验处理
        if(errors.hasErrors())
        {
            return Result.genResult(ResultCode.INPUT_DATA_ERROR.getCode(), ResultCode.INPUT_DATA_ERROR.getMsg());
        }

        return Result.ok(selectorService.buildConfiguration(buildConfigurationInputDTO));
    }

    @PostMapping("/conflictAnalysis")
    @BusinessLog
    public Result<ConflictAnalysisOutputDTO> conflictAnalysis(@Valid @RequestBody ConflictAnalysisInputDTO conflictAnalysisInputDTO,
                                                              Errors errors)
    {
        //校验处理
        if(errors.hasErrors())
        {
            return Result.genResult(ResultCode.INPUT_DATA_ERROR.getCode(), ResultCode.INPUT_DATA_ERROR.getMsg());
        }

        return Result.ok(selectorService.conflictAnalysis(conflictAnalysisInputDTO));
    }

    @PostMapping("/postVerify")
    @BusinessLog
    public Result<PostVerifyOutputDTO> postVerify(@Valid @RequestBody PostVerifyInputDTO postVerifyInputDTO,
                                                  Errors errors)
    {
        //校验处理
        if(errors.hasErrors())
        {
            return Result.genResult(ResultCode.INPUT_DATA_ERROR.getCode(), ResultCode.INPUT_DATA_ERROR.getMsg());
        }

        return Result.ok(selectorService.postVerify(postVerifyInputDTO));
    }

    @PostMapping(value = "/copyConfiguration")
    @ResponseStatus(HttpStatus.OK)
    @BusinessLog(action = "复制配置")
    public Result<CopyConfigurationOutputDTO> copyConfiguration(@Valid @RequestBody CopyConfigurationInputDTO copyConfigurationInputDTO,
                                                                Errors errors) {
        //校验处理
        if(errors.hasErrors())
        {
            return Result.genResult(ResultCode.INPUT_DATA_ERROR.getCode(), ResultCode.INPUT_DATA_ERROR.getMsg());
        }

        return Result.ok(selectorService.copyConfiguration(copyConfigurationInputDTO));
    }

    @PostMapping(value = "/configurations")
    @ResponseStatus(HttpStatus.OK)
    @BusinessLog(action = "获取配置")
    public Result<List<GetConfigurationOutputDTO>> getConfigurations(@Valid @RequestBody GetConfigurationInputDTO getConfigurationInputDTO,
                                                                     Errors errors) {
        //校验处理
        if(errors.hasErrors())
        {
            return Result.genResult(ResultCode.INPUT_DATA_ERROR.getCode(), ResultCode.INPUT_DATA_ERROR.getMsg());
        }

        return Result.ok(selectorService.getConfigurations(getConfigurationInputDTO.getConfigIds()));
    }
}
