package com.lcrx.selector.constant;

import java.text.MessageFormat;

/**
 * @author ###
 */
public class RedisKey {
    /**
     * 系统:产品组:物料编号
     */
    private static final String VARIANT_TABLE = "selector:{0}:{1}:{2}:variantTable";
    /**
     * 系统
     */
    private static final String QUANTITY_MAPPING = "selector:{0}:quantityMapping";
    /**
     * 系统
     */
    private static final String TOTAL_QUANTITY_MAPPING = "selector:{0}:totalQuantityMapping";
    /**
     * TOTAL特征和特征值的缓存id
     */
    private static final String TOTAL_CHARACTERISTIC = "selector:characteristic:total:{0}";
    /**
     * 选中的特征和特征值的缓存id
     */
    private static final String SELECTED_CHARACTERISTIC = "selector:characteristic:selected:{0}";

    public static String getVariantTableKey(String systemCode,
                                            String productGroupCode,
                                            String materialCode) {
        return MessageFormat.format(VARIANT_TABLE, systemCode, productGroupCode, materialCode);
    }

    public static String getTotalCharacteristicKey(String snowFlakeId) {
        return MessageFormat.format(TOTAL_CHARACTERISTIC, snowFlakeId);
    }

    public static String getSelectedCharacteristicKey(String snowFlakeId) {
        return MessageFormat.format(SELECTED_CHARACTERISTIC, snowFlakeId);
    }

    public static String getQuantityMappingKey(String systemCode) {
        return MessageFormat.format(QUANTITY_MAPPING, systemCode);
    }

    public static String getTotalQuantityMappingKey(String systemCode) {
        return MessageFormat.format(TOTAL_QUANTITY_MAPPING, systemCode);
    }
}
