package com.lcrx.selector.entity.DTO;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * @author ###
 */
@NoArgsConstructor
@Data
public class BuildConfigurationInputDTO implements Serializable {

    /**
     * productGroupCode : ###
     * materialCode : ###
     * operator : ###
     * selectedComplete : true
     * sessionId : 会话Id，服务记录total信息的值
     * selectedCharacteristicList : [{"characteristicName":"特征名称","characteristicValueName":"特征值名称","quantity":1}]
     * keyValues : [{"key":"mode","value":"edit"}]
     */

    @NotNull
    private String productGroupCode;
    @NotNull
    private String materialCode;
    @NotNull
    private String operator;
    @NotNull
    private Boolean selectedComplete;
    @NotNull
    private String sessionId;
    @NotNull
    @Size(min = 1)
    private List<SelectedCharacteristicListBean> selectedCharacteristicList;
    private List<KeyValuesBean> keyValues;

    @NoArgsConstructor
    @Data
    public static class SelectedCharacteristicListBean implements Serializable {
        /**
         * characteristicName : 特征名称
         * characteristicValueName : 特征值名称
         * quantity : 1
         */

        private String characteristicName;
        private String characteristicValueName;
        private int quantity;
        private String desc;
    }

    @NoArgsConstructor
    @Data
    public static class KeyValuesBean implements Serializable {
        /**
         * key : mode
         * value : edit
         */

        private String key;
        private String value;
    }
}
