package com.lcrx.selector.entity.DTO;

import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author ###
 */
@NoArgsConstructor
@Data
public class ConflictAnalysisInputDTO implements Serializable {

    /**
     * productGroupCode : 03
     * materialCode : 90FYCTO1WW
     * operator : LIUJJ16
     * characteristicName : 特征名称
     * characteristicValueName : 特征值名称
     * sessionId : 会话Id，redis记录total特征信息，不用再传
     * selectedCharacteristicList : [{"characteristicName":"特征名称","characteristicValueName":"特征值名称"}]
     * mustSelection : false
     */

    @NotNull
    private String productGroupCode;
    @NotNull
    private String materialCode;
    @NotNull
    private String operator;
    @NotNull
    private String characteristicName;
    @NotNull
    private String characteristicValueName;
    @NotNull
    private String sessionId;
    @NotNull
    private Boolean mustSelection;
    @NotNull
    private List<SelectedCharacteristicListBean> selectedCharacteristicList;

    @NoArgsConstructor
    @Data
    public static class SelectedCharacteristicListBean implements Serializable {
        /**
         * characteristicName : 特征名称
         * characteristicValueName : 特征值名称
         */

        private String characteristicName;
        private String characteristicValueName;
        private int quantity;
        private String desc;
    }
}
