package com.lcrx.selector.entity.DTO;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author ###
 */
@NoArgsConstructor
@Data
public class ConflictAnalysisOutputDTO implements Serializable {

    /**
     * conflictCharacteristicList : ["冲突的特征值的Name"]
     * activeValues : [{"characteristicName":"###","values":["##"]},{"characteristicName":"###","values":["##","##","##"]}]
     * selectedCharacteristicList : [{"characteristicName":"DTPRODUCTNAME90FY","characteristicValueName":"QTM610-N000"}]
     * mustSelectionResult : true
     */

    private Boolean mustSelectionResult;
    private List<String> conflictCharacteristicList;
    private List<ActiveValuesBean> activeValues;
    private List<SelectedCharacteristicListBean> selectedCharacteristicList;

    @NoArgsConstructor
    @Data
    public static class ActiveValuesBean implements Serializable {
        /**
         * characteristicName : ###
         * values : ["##"]
         */

        private String characteristicName;
        private List<String> values;
    }

    @NoArgsConstructor
    @Data
    public static class SelectedCharacteristicListBean implements Serializable {
        /**
         * characteristicName : DTPRODUCTNAME90FY
         * characteristicValueName : QTM610-N000
         */

        private String characteristicName;
        private String characteristicValueName;
        private int quantity;
        private String desc;
    }
}
