package com.lcrx.selector.entity.DTO;

import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * @author ###
 */
@NoArgsConstructor
@Data
@Getter
public class InitializationInputDTO implements Serializable {

    /**
     * system : 调用系统
     * productGroupCode : 产品组编号
     * materialCode : 物料编号
     * operator : ###
     * configId :
     * characteristicList : [{"Name":"特征名称，CTO下唯一","pairCharacteristicName":"匹配的数量型C","type":0,"isDerive":0,"values":[{"Name":"特征值Name，特征下唯一"}]}]
     * keyValues : [{"key":"action","value":"edit"},{"key":"###","value":"###"}]
     */

    @NotNull
    private String system;
    @NotNull
    private String productGroupCode;
    @NotNull
    private String materialCode;
    @NotNull
    private String operator;
    private String configId;
    @NotNull
    @Size(min = 1)
    private List<CharacteristicListBean> characteristicList;
    private List<KeyValuesBean> keyValues;

    @NoArgsConstructor
    @Data
    public static class CharacteristicListBean implements Serializable {
        /**
         * Name : 特征名称，CTO下唯一
         * pairCharacteristicName : 匹配的数量型C
         * type : 0
         * isDerive : 0 是派生的特征
         * invisibleForSales: 0 销售是否可见的标识
         * values : [{"Name":"特征值Name，特征下唯一"}]
         */

        private String name;
        private String pairCharacteristicName;
        private int type;
        private int isDerive;
        private int invisibleForSales;
        private List<ValuesBean> values;

        @NoArgsConstructor
        @Data
        public static class ValuesBean implements Serializable {
            /**
             * Name : 特征值Name，特征下唯一
             */

            private String name;
            private List<KeyValuesBean> keyValues;
        }
    }

    @NoArgsConstructor
    @Data
    public static class KeyValuesBean implements Serializable {
        /**
         * key : action
         * value : edit
         */

        private String key;
        private String value;
    }
}
