package com.lcrx.selector.entity.DTO;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author ###
 */
@NoArgsConstructor
@Data
public class InitializationOutputDTO implements Serializable {

    /**
     * materialCode : ###
     * productGroupCode : ###
     * sessionId : 会话Id，服务记录total信息的值
     * characteristicList : [{"Name":"特征Value，CTO下唯一","pairCharacteristicValue":"匹配的数量型C","type":0,"isDerive":0,"values":[{"Name":"特征值Name，特征下唯一","isolated":false,"keyValues":[{"key":"###","value":"###"}]}]}]
     * activeValues : [{"characteristicName":"###","values":["##"]},{"characteristicName":"###","values":["##","##","##"]}]
     * selectedValues : [{"characteristicName":"###","characteristicValueName":"##"},{"characteristicName":"###","characteristicValueName":"##"}]
     * keyValues : [{"key":"fast_path","value":"1"}]
     */

    private String materialCode;
    private String productGroupCode;
    private String sessionId;
    private List<CharacteristicListBean> characteristicList;
    private List<String> constraintCharacteristicNames;
    private List<ActiveValuesBean> activeValues;
    private List<SelectedValuesBean> selectedValues;
    private List<KeyValuesBean> keyValues;

    @NoArgsConstructor
    @Data
    public static class CharacteristicListBean implements Serializable {
        /**
         * Name : 特征Value，CTO下唯一
         * pairCharacteristicValue : 匹配的数量型C
         * type : 0
         * isDerive : 0
         * values : [{"Name":"特征值Name，特征下唯一","isolated":false,"keyValues":[{"key":"###","value":"###"}]}]
         */

        private String Name;
        private String pairCharacteristicValueName;
        private int type;
        private int isDerive;
        private List<ValuesBean> values;

        @NoArgsConstructor
        @Data
        public static class ValuesBean implements Serializable {
            /**
             * Name : 特征值Name，特征下唯一
             * isolated : false
             * keyValues : [{"key":"###","value":"###"}]
             */

            private String Name;
            private Boolean isolated;
            private List<KeyValuesBean> keyValues;

        }
    }

    @NoArgsConstructor
    @Data
    public static class ActiveValuesBean implements Serializable {
        /**
         * characteristicName : ###
         * values : ["##"]
         */

        private String characteristicName;
        private List<String> values;
    }

    @NoArgsConstructor
    @Data
    public static class SelectedValuesBean implements Serializable {
        /**
         * characteristicName : ###
         * characteristicValueName : ##
         */

        private String characteristicName;
        private String characteristicValueName;
        private int quantity;
        private String desc;
        private Boolean available;
    }

    @NoArgsConstructor
    @Data
    public static class KeyValuesBean implements Serializable {
        /**
         * key : fast_path
         * value : 1
         */

        private String key;
        private String value;
    }
}
