package com.lcrx.selector.entity.DTO;

import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * @author ###
 */
@NoArgsConstructor
@Data
public class PostVerifyInputDTO implements Serializable {

    /**
     * productGroupCode : 03
     * materialCode : 90G3CTO1WW
     * operator : LIUJJ16
     * sessionId : 1447404367220871169
     * selectedCharacteristicList : [{"characteristicName":"DTEXTERNAL_USB_PORT_CABLE","characteristicValueName":"FRONT_X4_REAR_X4_USB_PORTS","quantity":1},{"characteristicName":"DTPOWER_SUPPLY","characteristicValueName":"180W_85_ES_TFX","quantity":1}]
     * keyValues : [{"key":"mode","value":"edit"}]
     */

    @NotNull
    private String productGroupCode;
    @NotNull
    private String materialCode;
    @NotNull
    private String operator;
    @NotNull
    private String sessionId;
    @NotNull
    @Size(min = 1)
    private List<SelectedCharacteristicListBean> selectedCharacteristicList;
    private List<KeyValuesBean> keyValues;

    @NoArgsConstructor
    @Data
    public static class SelectedCharacteristicListBean implements Serializable {
        /**
         * characteristicName : DTEXTERNAL_USB_PORT_CABLE
         * characteristicValueName : FRONT_X4_REAR_X4_USB_PORTS
         * quantity : 1
         */

        private String characteristicName;
        private String characteristicValueName;
        private int quantity;
    }

    @NoArgsConstructor
    @Data
    public static class KeyValuesBean implements Serializable {
        /**
         * key : mode
         * value : edit
         */

        private String key;
        private String value;
    }
}
