package com.lcrx.selector.entity.DTO;

import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author ###
 */
@NoArgsConstructor
@Data
public class PreVerifyInputDTO implements Serializable {

    /**
     * characteristicName : 特征Name
     * productGroupCode : ##
     * materialCode : ###
     * operator : ###
     * characteristicValueName : 特征值Name
     * sessionId : 会话Id，redis记录total特征信息，不用再传
     * keyValues : [{"key":"mode","value":"edit"}]
     */

    @NotNull
    private String characteristicName;
    @NotNull
    private String productGroupCode;
    @NotNull
    private String materialCode;
    @NotNull
    private String operator;
    @NotNull
    private String characteristicValueName;
    @NotNull
    private String sessionId;
    @NotNull
    private List<SelectedCharacteristicListBean> selectedCharacteristicList;
    private List<KeyValuesBean> keyValues;

    @NoArgsConstructor
    @Data
    public static class KeyValuesBean implements Serializable {
        /**
         * key : mode
         * value : edit
         */

        private String key;
        private String value;
    }

    @NoArgsConstructor
    @Data
    public static class SelectedCharacteristicListBean implements Serializable {
        /**
         * characteristicName : ###
         * characteristicValueName : ##
         */

        private String characteristicName;
        private String characteristicValueName;
        private int quantity;
        private String desc;
    }
}
