package com.lcrx.selector.entity.PO;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

/**
 * @author ###
 */
@Builder
@Data
@EqualsAndHashCode(exclude = {"configurationCharacteristicValuePOList"})
@ToString(exclude = {"configurationCharacteristicValuePOList"})
@NoArgsConstructor
@AllArgsConstructor
@Entity
@Table(name = "configuration_basis")
@EntityListeners(AuditingEntityListener.class)
public class ConfigurationBasisPO {
    @Id
    @Column(name = "config_id")
    private Long configId;

    @Column(name = "product_group_code")
    private String productGroupCode;

    @Column(name = "material_code")
    private String materialCode;

    @Column(name = "operator")
    private String operator;

    @Column(name = "create_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date createTime;

    @OneToMany(mappedBy = "configurationBasisPO", cascade = CascadeType.ALL, orphanRemoval = true, fetch = FetchType.LAZY)
    private List<ConfigurationCharacteristicValuePO> configurationCharacteristicValuePOList;
}
