package com.lcrx.selector.entity.PO;

import com.lcrx.selector.entity.PO.ConfigurationBasisPO;
import lombok.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;

/**
 * @author ###
 */
@Builder
@Data
@EqualsAndHashCode(exclude = {"configurationBasisPO"})
@ToString(exclude = {"configurationBasisPO"})
@NoArgsConstructor
@AllArgsConstructor
@Entity
@Table(name = "configuration_characteristic_and_value")
@EntityListeners(AuditingEntityListener.class)
public class ConfigurationCharacteristicValuePO {
    @Id
    @Column(name = "id")
    private Long id;

    @Column(name = "config_id", insertable = false, updatable = false)
    private Long configId;

    @Column(name = "characteristic_name")
    private String characteristicName;

    @Column(name = "characteristic_value_name")
    private String characteristicValueName;

    @Column(name = "characteristic_value_quantity")
    private Integer characteristicValueQuantity;

    @Column(name = "characteristic_value_desc")
    private String characteristicValueDesc;

    @ManyToOne(cascade = CascadeType.REFRESH, fetch = FetchType.LAZY)
    @JoinColumn(name = "config_id")
    private ConfigurationBasisPO configurationBasisPO;
}
