package com.lcrx.selector.exception;

import com.lcrx.selector.utils.result.ResultCode;

/**
 * 说明: 权限异常
 * 用户没有权限,无 token, token 过期, token 不可用等
 */
public class AuthorityException extends RuntimeException{

    private static final long serialVersionUID = -1L;

    public static final ResultCode TYPE = ResultCode.AUTHORITY;

    public AuthorityException(String msg) {
        super(msg);
    }

    public AuthorityException(String msg, Throwable e) {
        super(msg, e);
    }

    public AuthorityException(Throwable e) {
        super(e);
    }

    public static AuthorityException e(String message) {
        return new AuthorityException(message);
    }
}
