package com.lcrx.selector.exception;

import com.lcrx.selector.utils.result.ResultCode;

/**
 * 说明: 业务异常
 * 业务本身不允许的异常
 * 例如，你在银行有一笔贷款，这笔贷款没有还完之前，不允许再次贷款。这种异常需要根据业务本身来指定。
 */
public class BusinessException extends RuntimeException{

    private static final long serialVersionUID = -1L;

    public static final ResultCode TYPE = ResultCode.BUSINESS;

    public BusinessException(String msg) {
        super(msg);
    }

    public BusinessException(String msg, Throwable e) {
        super(msg, e);
    }

    public BusinessException(Throwable e) {
        super(e);
    }

    public static BusinessException e(String message) {
        return new BusinessException(message);
    }
}
