package com.lcrx.selector.exception;

import com.lcrx.selector.utils.result.ResultCode;

/**
 * 说明: 数据异常
 * 1.1	 传入参数合法性校验异常
 * 例如入参非空校验，长度校验，格式校验等不符合规范
 * 1.2	 传入参数有效性校验的异常
 * 例如传入的商品id，格式没有问题，但是根据这个id查询不到对应的商品
 *
 */
public class DataException extends RuntimeException{

    private static final long serialVersionUID = -1L;

    public static final ResultCode TYPE = ResultCode.DATA;

    public DataException(String msg) {
        super(msg);
    }

    public DataException(String msg, Throwable e) {
        super(msg, e);
    }

    public DataException(Throwable e) {
        super(e);
    }

    public static DataException e(String message) {
        return new DataException(message);
    }
}
