package com.lcrx.selector.exception;

import com.lcrx.selector.utils.result.Result;
import com.lcrx.selector.utils.result.ResultCode;

/**
 * 说明: 服务异常
 * 调用其他服务异常
 * 例如，订单服务调用商品服务，商品服务一致没有反应，或者商品服务那边报错，没有返回预期数据，而是返回了一个错误。
 * @author :chengzi
 * Create :2019/8/13 13:54
 */
public class ServiceException extends RuntimeException{

    private static final long serialVersionUID = -1L;

    public static final ResultCode TYPE = ResultCode.SERVICE;

    public ServiceException(String msg) {
        super(msg);
    }

    public ServiceException(String msg, Throwable e) {
        super(msg, e);
    }

    public ServiceException(Throwable e) {
        super(e);
    }

    public static ServiceException e(String message) {
        return new ServiceException(message);
    }

    public static ServiceException e(String message, Throwable e) {
        return new ServiceException(message,e);
    }

    public static String getServiceErrorResult(Result result) {
        return ResultCode.SERVICE.getMsg() + ": " + result.getMessage() + ": " + result.getTrace();
    }
}
