package com.lcrx.selector.exception;

import com.lcrx.selector.utils.result.ResultCode;

/**
 * 说明: 系统异常
 * 系统本身的异常
 * 例如，一些运行时异常，数据传输异常，数据库异常，网络异常等。
 */
public class SysException extends RuntimeException{

    private static final long serialVersionUID = -1L;

    public static final ResultCode TYPE = ResultCode.SYS;

    public SysException(String msg) {
        super(msg);
    }

    public SysException(String msg, Throwable e) {
        super(msg, e);
    }

    public SysException(Throwable e) {
        super(e);
    }

    public static SysException e(String message) {
        return new SysException(message);
    }
}
