package com.lcrx.selector.utils.result;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 统一API响应结果封装 * 新增对应枚举值的封装
 * @author chengzi
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "响应结果集")
public class Result<T> implements Serializable {

    /**
     * 返回的code
     */
    @ApiModelProperty(value = "自定义请求状态码")
    private Integer result;
    /**
     * 返回的文言
     */
    @ApiModelProperty(value = "自定义请求状态说明")
    private String message;
    /**
     * 返回的数值
     */
    @ApiModelProperty(value = "数据结果")
    private T data;

    /**
     * 接口总耗时
     */
    @ApiModelProperty(value = "接口耗时")
    private Long took;

    /**
     * 异常堆栈信息
     */
    @ApiModelProperty(value = "异常堆栈信息")
    public String trace;

    public static <T> Result<T> ok() {
        return ok(ResultCode.SUCCESS.getMsg(), null);
    }
    public static <T> Result<T> ok(T data) {
        return ok(ResultCode.SUCCESS.getMsg(), data);

    }
    public static <T> Result<T> ok(String message, T data) {
        return Result.<T>builder()
                .result(ResultCode.SUCCESS.getCode()).message(ResultCode.SUCCESS.getMsg()).data(data)
                .build();
    }


    /**
     * 自定义 code和 message
     * @return 本身
     */
    public static <T> Result<T> genResult(Integer code, String message) {
        return Result.<T>builder()
                .result(code).message(message).build();
    }

    /**
     * 自定义 code和 message
     * @return 本身
     */
    public static <T> Result<T> genResult(Integer code, String message,String trace) {
        return Result.<T>builder()
                .result(code).message(message).trace(trace).build();
    }

    public static <T> Result<T> genResult(Integer code, String message, T data) {
        return Result.<T>builder()
                .result(code).message(message).data(data).build();
    }

    public boolean success() {
        return ResultCode.SUCCESS.getCode() == result || 0 == result;
    }
}
