package com.lcrx.selector.utils.result;

import java.util.HashMap;
import java.util.Map;

/**
 * @author
 * 状态码
 */
public enum ResultCode {

    /**
     * 操作成功
     */
    SUCCESS(200, "操作成功!"),

    /**
     *  数据异常
     */
    DATA(400,"数据异常"),

    /**
     *  权限异常
     */
    AUTHORITY(403,"权限异常"),

    /**
     *  业务异常
     */
    BUSINESS(405,"业务异常"),

    /**
     *  系统异常
     */
    SYS(500,"系统异常"),

    /**
     *  三方服务调用异常
     */
    SERVICE(501,"三方服务调用异常"),

    /**
     *  未知异常
     */
    UNKNOWN(9999,"未知异常"),

    /**
     *  传入的参数异常
     */
    INPUT_DATA_ERROR(10001,"传入的参数异常");


    ResultCode(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    /**
     * code
     */
    private final int code;
    /**
     * 文言
     */
    private final String msg;


    public int getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    /**
     * 根据key获取value
     *
     * @param code : 键值key
     * @return String
     */
    public static String getMsgByCode(int code) {
        ResultCode[] enums = ResultCode.values();
        for (int i = 0; i < enums.length; i++) {
            if (enums[i].getCode() == code) {
                return enums[i].getMsg();
            }
        }
        return "";
    }

    /**
     * 转换为MAP集合
     *
     * @returnMap<String, String>
     */
    public static Map<String, String> toMap() {
        Map<String, String> map = new HashMap<String, String>();
        ResultCode[] enums = ResultCode.values();
        for (int i = 0; i < enums.length; i++) {
            String key = String.valueOf(enums[i].getCode());
            map.put(key, enums[i].getMsg());
        }
        return map;
    }

}
