
spring-microservice-exam的模块结构

### 模块说明

```
common  -- 系统公共模块 
    ├── common-core -- 系统公共核心模块 
    ├── common-feign -- 系统公共feign模块 
    ├── common-log -- 系统公共日志模块
    └── common-security -- 系统公共安全模块，包括资源服务器配置
service-api -- 服务api公共模块 
    ├── user-api -- 用户服务api
    └── exam-api -- 考试服务api
service-api-impl -- 服务api模块实现
    ├── auth-service    -- 授权服务（OAuth2.0）
    ├── user-service    -- 用户服务
    └── exam-service    -- 考试服务
config-service  -- 配置中心（本地仓库）
gateway-service -- 网关（动态路由）
monitor-service -- spring boot amdin 监控服务
```

`common-core`: 封装通用配置、常量、异常、基础实体等

`common-feign`：封装通用feign配置，用于服务调用间携带access_token

`common-log`：封装日志记录逻辑，异步记录日志

`common-security`: 封装OAuth2.0中的资源服务器通用配置

