主要介绍如何基于docker、docker-compose部署后端项目、前端项目，主要的步骤是本地构建镜像，推送的远程仓库，远程服务器从远程仓库拉去镜像运行

## 前提

- 服务器：2核4G、CentOS 7.2 64位

- 注册阿里云账号

## 安装MySQL

MySQL需要单独安装，创建数据库和执行初始化脚本：

`/docs/deploy/mysql/init/microservice-user.sql`

`/docs/deploy/mysql/init/microservice-exam.sql`

`/docs/deploy/mysql/init/microservice-auth.sql`

`/docs/deploy/mysql/init/microservice-gateway.sql`

## 安装docker、docker-compose

linux系统安装`docker`、`docker-compose`

windows系统安装`Docker for Windows`

## 安装fastDfs

参考：[fastdfs文件系统单机环境搭建和spring boot整合](https://blog.csdn.net/baidu_36415076/article/details/79505027)

## 修改配置

在服务器的根目录创建文件夹：`spring-microservice-exam`

将源码目录下的`docker-compose.env`、`docker-compose-base.yml`、`docker-compose-services.yml`、`docker-compose-nginx.yml`、`nginx.conf`上传到服务器的`/spring-microservice-exam/`目录下

将启动脚本`docs/deploy/start.sh`上传到服务器的`/spring-microservice-exam/`目录下

目录结构：

![image](images/deploy/docker_root.png)

修改`docker-compose.env`

包括数据库IP、端口、用户名和密码，fastDfs的IP、端口

![image](images/deploy/config_docker_env.png)

## 运行

1. 登录阿里云Docker Registry

```
$ docker login --username=你的阿里云账号 registry.cn-hangzhou.aliyuncs.com

如：docker login --username=tb70177569 registry.cn-hangzhou.aliyuncs.com
```

2. 拉取镜像并启动：`./start.sh pullrun`

3. 检查是否启动成功：`docker ps`

## 访问

前台地址：ip:80

后台地址：ip:81

## 其它命令

1. 停止容器：`./start.sh stop`
2. 删除所有容器：`./start.sh removeAll`
3. 重启所有容器：`./start.sh restart`
4. 拉取并启动：`./start.sh pullrun`

## 参考资料

- [安装docker](https://www.cnblogs.com/yufeng218/p/8370670.html)

- [安装docker-compose](https://www.jianshu.com/p/94760f35c98c)

- [在线考试系统V3.0镜像构建、推送、部署](http://ehedgehog.net/2019/04/22/%E5%9C%A8%E7%BA%BF%E8%80%83%E8%AF%95%E7%B3%BB%E7%BB%9FV2.0%E9%95%9C%E5%83%8F%E6%9E%84%E5%BB%BA%E3%80%81%E6%8E%A8%E9%80%81%E3%80%81%E9%83%A8%E7%BD%B2/)