
spring-microservice-exam的模块结构

### 模块说明

```
common  -- 系统公共模块 
    ├── common-core -- 系统公共核心模块 
    ├── common-feign -- 系统公共feign模块 
    ├── common-log -- 系统公共日志模块
    └── common-security -- 系统公共安全模块，包括资源服务器配置
modules -- 业务模块 
    |-- auth-service-parent -- 认证授权服务
        |-- auth-service-api -- 认证授权服务api
        |-- auth-service -- 认证授权服务具体实现
    |-- user-service-parent -- 用户服务
        |-- user-service-api -- 用户服务api
        |-- user-service -- 用户服务具体实现
    |── exam-service-parent -- 考试服务
        |-- exam-service-api -- 考试服务api
        |-- exam-service -- 考试服务具体实现
    └── msc-service-parent -- 消息中心
        |-- msc-service-api -- 消息中心api
        |-- msc-service -- 消息中心具体实现

config-service  -- 配置中心（本地仓库）
gateway-service -- 网关（动态路由）
monitor-service -- spring boot amdin 监控服务
```

`common-core`: 封装通用配置、常量、异常、基础实体等

`common-feign`：封装通用feign配置，用于服务调用间携带access_token

`common-log`：封装日志记录逻辑，异步记录日志

`common-security`: 封装OAuth2.0中的资源服务器通用配置

